<?php

namespace AmeliaBooking\Infrastructure\WP\Integrations\ThriveAutomator\Triggers\Booking;

use AmeliaBooking\Infrastructure\WP\Integrations\ThriveAutomator\Apps\AmeliaBooking;
use AmeliaBooking\Infrastructure\WP\Integrations\ThriveAutomator\DataObjects\AppointmentBookingData;
use Thrive\Automator\Items\Trigger;

class AppointmentBookingAdded extends Trigger
{
    public static function get_id()
    {
        return 'ameliabooking/appointment-booking-added-trigger';
    }

    public static function get_wp_hook()
    {
        return 'AmeliaAppointmentBookingAdded';
    }

    public static function get_provided_data_objects()
    {
        return [
            AppointmentBookingData::get_id(),
        ];
    }

    public static function get_hook_params_number()
    {
        return 2;
    }

    public static function get_app_id()
    {
        return AmeliaBooking::get_id();
    }

    public static function get_name()
    {
        return 'Appointment Booking Created';
    }

    public static function get_description()
    {
        return 'When appointment booking is created';
    }

    public static function get_image()
    {
        return AMELIA_URL . 'public/img/amelia-logo-symbol.svg';
    }
}
