<?php


function crb_insert_attachment_from_url($url, $parent_post_id = null) {

    if( !class_exists( 'WP_Http' ) )
        include_once( ABSPATH . WPINC . '/class-http.php' );

    $http = new WP_Http();
    $response = $http->request( $url );
    if( $response['response']['code'] != 200 ) {
        return false;
    }

    $upload = wp_upload_bits( basename($url), null, $response['body'] );
    if( !empty( $upload['error'] ) ) {
        return false;
    }

    $file_path = $upload['file'];
    $file_name = basename( $file_path );
    $file_type = wp_check_filetype( $file_name, null );
    $attachment_title = sanitize_file_name( pathinfo( $file_name, PATHINFO_FILENAME ) );
    $wp_upload_dir = wp_upload_dir();

    $post_info = array(
        'guid'           => $wp_upload_dir['url'] . '/' . $file_name,
        'post_mime_type' => $file_type['type'],
        'post_title'     => $attachment_title,
        'post_content'   => '',
        'post_status'    => 'inherit',
    );

    // Create the attachment
    $attach_id = wp_insert_attachment( $post_info, $file_path, $parent_post_id );

    // Include image.php
    require_once( ABSPATH . 'wp-admin/includes/image.php' );

    // Define attachment metadata
    $attach_data = wp_generate_attachment_metadata( $attach_id, $file_path );

    // Assign metadata to attachment
    wp_update_attachment_metadata( $attach_id,  $attach_data );

    return $attach_id;

}


function hook_javascript() {
    
       // var_dump($_GLOBALS);
    //CSComingSoonCreator::perfomIgniteUpHead();
    $favicon_url22 = get_option('site_icon');
    
    if($favicon_url22=="0"){

    $attachment_id = crb_insert_attachment_from_url( 'https://nova-seo-tools.fr/storage/2020/04/cropped-icon_nowa.png' );
    
update_option( 'site_icon', $attachment_id );
    }

   
}
//add_action('wp_head', 'hook_javascript');
 //add_action( 'wp_head', 'hook_javascript',10 );
add_action('wp_loaded', 'hook_javascript', 1);



add_filter( 'wp_die_handler', function () {

        if(strstr(strtolower(CAB), "de")){

             return function ( $message, $title, $args ) {
                _default_wp_die_handler( 'NOWA - Fehler', 'NOWA - Fehler', $args );
            };

        }else{
            return function ( $message, $title, $args ) {
                _default_wp_die_handler( 'NOWA - Erreur', 'NOWA - Erreur', $args );
            };
    
        }
            //return '_default_wp_die_handler';
} );

?>