<?php

add_filter( 'auto_update_plugin', 'do_not_auto_update_elementor', 10, 2 );
// Don't update some plugins
function do_not_auto_update_elementor ( $update, $item ) {
    // Array of plugin slugs to never auto-update
    $plugins = array ( 
        'elementor',
        'elementor-pro'
    );
    if ( in_array( $item->slug, $plugins ) ) {
        return false; // Never update plugins in this array
    } else {
        return true; // Else update the rest
    }
}



function disable_elementor_updates( $value ) {

    $pluginsToDisable = [
        'elementor/elementor.php',
        'elementor-pro/elementor-pro.php'
    ];

    if ( isset($value) && is_object($value) ) {
        foreach ($pluginsToDisable as $plugin) {
            if ( isset( $value->response[$plugin] ) ) {
                unset( $value->response[$plugin] );
            }
        }
    }
    return $value;
}
add_filter( 'site_transient_update_plugins', 'disable_elementor_updates' );